unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
    FColorBegin,FColorEnd :TColor;
    function ObliczKolor(i :Integer) :TColor;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function TForm1.ObliczKolor(i :Integer) :TColor;
var W :Integer;
    RedBegin,RedEnd :Byte;
    GreenBegin,GreenEnd :Byte;
    BlueBegin,BlueEnd :Byte;
begin
W:=Width;

RedBegin:=GetRValue(FColorBegin);
GreenBegin:=GetGValue(FColorBegin);
BlueBegin:=GetBValue(FColorBegin);
RedEnd:=GetRValue(FColorEnd);
GreenEnd:=GetGValue(FColorEnd);
BlueEnd:=GetBValue(FColorEnd);

Result:=clNone;
if (i<0) or (i>W) then Exit;
Result:=RGB(
  RedBegin+i*(RedEnd-RedBegin) div W,
  GreenBegin+i*(GreenEnd-GreenBegin) div W,
  BlueBegin+i*(BlueEnd-BlueBegin) div W);
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  i :Integer;
begin
for i:=0 to ClientWidth do
begin
  Canvas.Pen.Color:=ObliczKolor(i);
  Canvas.MoveTo(i,0);
  Canvas.LineTo(i,ClientHeight);
end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
FColorBegin:=clBlue;
FColorEnd:=clBlack;
end;

end.
